import React from 'react';

interface SpinnerProps {
  size?: string;  // CSS size for width and height (e.g., "2rem", "48px")
  className?: string;
}

export const Spinner: React.FC<SpinnerProps> = ({
  size = "1rem",
  className = "",
}) => {
  return (
    <div
      className={`inline-block animate-spin rounded-full border-2 border-t-transparent border-primary ${className}`}
      style={{ width: size, height: size }}
      role="status"
      aria-label="Loading"
    />
  );
};